package service;


public abstract class Transition {
	private String name;
	/**
	 * Creates a new action
	 * @param name the name that identifies the name of the action, two action with the same name are equal.
	 */
	public Transition(String name){
		this.name=name;
	}
	
	/**
	 * This method returns the name of the action
	 * @return The string contains the name of the action
	 */
	public String getName(){
		return name;
	}
	/**
	 * This method returns the hashCode of the action
	 * @return The result contains the hashCode of the action
	 */
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((name == null) ? 0 : name.hashCode());
		return result;
	}
	/**
	 * This method compares an action with another object
	 * 
	 * @param obj
	 *            the other object used by the comparison
	 * @return Return true if and only if obj is a Action and the name's string of the
	 *         two action are equals
	 */
	
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		Transition other = (Transition) obj;
		if (name == null) {
			if (other.name != null)
				return false;
		} else if (!name.equals(other.name))
			return false;
		return true;
	}
	/** This method returns the source state of the action
	 * @return the source state of the action
	 */
	public abstract State getStateFrom();
	/** This method returns the target state of the action
	 * @return the target state of the action
	 */
	public abstract State getStateTo();
	
	/**
	 * Method that returns if a certain action simulates another
	 * @param act the action that simulates
	 * @return <code>true</code> if act2 simulates act1, <code>false</code> otherwise
	 */
	public boolean actionSimulates(Transition act){
		//just compares the name of the actions
		return this.getName().equals(act.getName());
	}

}
